<?php
/*--------------------------------------------------------------------
 ServiceProvider.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Product\TaxInfo;

use Gambio\Core\Event\EventListenerProvider;
use Gambio\Shop\Product\TaxInfo\Listener\OnGetSellingUnitTaxInfoEventListener;
use Gambio\Shop\SellingUnit\Database\Unit\Events\OnGetSellingUnitTaxInfoEvent;
use League\Container\Container;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;
use main_ORIGIN;

/**
 * Class ServiceProvider
 * @package Gambio\Shop\Product\TaxInfo
 * @property-read Container $container
 */
class ServiceProvider extends AbstractServiceProvider implements BootableServiceProviderInterface
{
    /**
     * @var string[]
     */
    protected $provides = [
        OnGetSellingUnitTaxInfoEventListener::class
    ];
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->container->share(OnGetSellingUnitTaxInfoEventListener::class)
            ->addArgument(main_ORIGIN::class);
        
        $this->container->share(main_ORIGIN::class);
    }
    
    
    /**
     * @inheritDoc
     */
    public function boot(): void
    {
        /**
         * @var EventListenerProvider $listenerProvider
         */
        $listenerProvider = $this->container->get(EventListenerProvider::class);
        $listenerProvider->attachListener(OnGetSellingUnitTaxInfoEvent::class, OnGetSellingUnitTaxInfoEventListener::class);
    }
}